<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class SeparationDeptController extends AbstractController
{
	
    /**
     * @Route("/separation-list", name="separation-list")
     */
    public function separationListActions(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		#--------[ FETCH
		$QURY	= "SELECT CONCAT(TM.tree_no_code,'/',TM.tree_no) AS tree_no, DATE_FORMAT(TMD.post_dt, '%b %D, %y %I:%i %p') AS entry_date, FORMAT(TM.tot_wgt, 3) AS tot_wgt, TMD.jc_no, TMD.jc_no_split_status, TMD.jc_no_split_status, TMD.item_qty, TMD.act_po_open_ord_det_id, TMD.po_open_ord_det_id, FORMAT(TMD.jc_orn_wgt, 3) AS jc_orn_wgt, TMD.wax_tree_making_det_id FROM `wax_tree_making_det` AS TMD, `wax_tree_making` AS TM, po_open_ord_det AS POD WHERE TMD.wax_tree_making_id=TM.wax_tree_making_id AND TMD.po_open_ord_det_id=POD.po_open_ord_det_id AND TMD.jc_orn_wgt!=0 ORDER BY TMD.jc_no DESC";
		$CONN	= $connection->executeQuery($QURY);
		$FTCH	= $CONN->fetchAll();	

		
		return $this->render('dept/separation-list.html.twig', [
			'seprateLIST' => $FTCH,
			'controller_name' => 'SeparationDeptController'
        ]);	
	}	

    /**
     * @Route("/separation-add", name="separation-add")
     */
    public function separationAddActions(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		date_default_timezone_set("Asia/Kolkata");
		$current_dt = date("Y-m-d");
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");	
		
		#--------[ FETCH - TREE NO
		//$QURYtreeNO = "SELECT `wax_tree_making_id`, CONCAT(tree_no_code,'/',tree_no) AS tree_no FROM `wax_tree_making` WHERE `role_status`=1 ORDER BY `wax_tree_making_id` ASC";
		$QURYtreeNO = "SELECT DISTINCT WTM.`wax_tree_making_id`, CONCAT(WTM.tree_no_code,'/',WTM.tree_no) AS tree_no FROM `wax_tree_making` AS WTM, `wax_tree_making_det` AS WTMD WHERE WTM.`role_status`=1 AND WTM.wax_tree_making_id=WTMD.wax_tree_making_id AND WTMD.jc_orn_wgt=0 ORDER BY WTM.`wax_tree_making_id` DESC";
		$CONNtreeNO = $connection->executeQuery($QURYtreeNO);
		$FTCHtreeNO = $CONNtreeNO->fetchAll();			
		
		#--------[ FETCH - EMP LIST
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();	
		
		if($request->getMethod() == 'POST')
		{
			$jcCONT  			= $request->get('jcCONT');
			$entry_date			= explode("-", $request->get('entry_date'));
			$entry_date			= $entry_date[2]."-".$entry_date[1]."-".$entry_date[0];
			$emp_id    			= $request->get('emp_id');
			
			for($i=0; $i<=$jcCONT; $i++)
			{
				$tree_making_det_id = $request->get('tree_making_det_id')[$i];
				$item_qty			= $request->get('item_qty')[$i];
				$wgt  				= $request->get('wgt')[$i];
				########-[ UPDATE - JC SEPRATION WGT

				$QRupdt = "UPDATE `wax_tree_making_det` SET `jc_orn_wgt`='$wgt', `item_qty`='$item_qty', `sepration_emp_id`='$emp_id', `sepration_date`='$entry_date' WHERE `wax_tree_making_det_id`='$tree_making_det_id'";
				$CNupdt = $connection->executeQuery($QRupdt);						
			}
			
			return $this->redirect('separation-list');
		}		
		
		return $this->render('dept/separation-add.html.twig', [
			'treeNOlist' => $FTCHtreeNO,
			'empLIST' => $FTCHemp,
			'controller_name' => 'SeparationDeptController'
        ]);	
	}

    /**
     * @Route("/split-jc{jcID}", name="split-jc")
     */
    public function splitJCactions(Request $request, $jcID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		date_default_timezone_set("Asia/Kolkata");
		$current_dt = date("Y-m-d");
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");	
		
		#--------[ FETCH - JC No DATA
		//$QURYjcNO = "SELECT `jc_no`, `item_qty`, FORMAT(`jc_orn_wgt`, 3) AS jcOrnWgt FROM `wax_tree_making_det` WHERE `wax_tree_making_det_id`='".$jcID."' AND `role_status`='1'";
		$QURYjcNO  = "SELECT SEP.*, FORMAT(SEP.`jc_orn_wgt`, 3) AS jcOrnWgt, POOPEN.* FROM `wax_tree_making_det` AS SEP, po_open_ord_det AS POOPEN WHERE SEP.`wax_tree_making_det_id`='".$jcID."' AND SEP.`role_status`='1' AND SEP.po_open_ord_det_id = POOPEN.po_open_ord_det_id AND POOPEN.`role_status`='1'";
		$CONNjcNO  = $connection->executeQuery($QURYjcNO);
		$FTCHjcNO  = $CONNjcNO->fetchAll();
		
		$openORDjc = $FTCHjcNO[0]['jc_no'];
		$po_open_ord_id = $FTCHjcNO[0]['po_open_ord_id'];
		$cat_shortname 	= $FTCHjcNO[0]['cat_shortname'];
		$typ_e 			= $FTCHjcNO[0]['typ_e'];
		$wgt_range_from	= $FTCHjcNO[0]['wgt_range_from'];
		$wgt_range_to	= $FTCHjcNO[0]['wgt_range_to'];
		$avg_wgt_per_pcs= $FTCHjcNO[0]['avg_wgt_per_pcs'];
		$ord_qty		= $FTCHjcNO[0]['ord_qty'];
		$avg_wgt_range	= $FTCHjcNO[0]['avg_wgt_range'];
		$ord_spec		= $FTCHjcNO[0]['ord_spec'];
		$ord_status		= $FTCHjcNO[0]['ord_status'];
		
		$wax_tree_making_id		= $FTCHjcNO[0]['wax_tree_making_id'];
		$po_open_ord_det_id		= $FTCHjcNO[0]['po_open_ord_det_id'];
		$wax_tree_making_det_id	= $FTCHjcNO[0]['wax_tree_making_det_id'];
		$st_wg					= $FTCHjcNO[0]['st_wg'];
		$sepration_emp_id		= $FTCHjcNO[0]['sepration_emp_id'];
		$sepration_date			= $FTCHjcNO[0]['sepration_date'];
		
		#--------[ FETCH - EMP LIST
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();	
		
		if($request->getMethod() == 'POST')
		{
			$tot_jc_split_cont = count($request->get('job_card_no'));
			
			for($i=0; $i<=$tot_jc_split_cont-1; $i++)
			{
				$job_card_no 	= $request->get('job_card_no')[$i];
				$qty 			= $request->get('qty')[$i];
				$jc_split_wgt	= $request->get('jc_split_wgt')[$i];
				
				#--------[ INSERT SPLIT OPEN ORDER - DETAILS
				$instOPENordDETAILS = "INSERT INTO `po_open_ord_det`(`po_open_ord_id`, `jc_no`, `jc_no_split_status`, `cat_shortname`, `typ_e`, `wgt_range_from`, `wgt_range_to`, `avg_wgt_per_pcs`, `ord_qty`, `avg_wgt_range`, `ord_spec`, `ord_status`, `post_by`, `post_dt`) VALUES ('$po_open_ord_id', '$job_card_no', 'No', '$cat_shortname', '$typ_e', '$wgt_range_from', '$wgt_range_to', '$avg_wgt_per_pcs', '$ord_qty', '$avg_wgt_range', '$ord_spec', '$ord_status', '$sessionId', '$nowDateTime')";
				$stmtOPENordDETAILS = $connection->executeQuery($instOPENordDETAILS);
				$LAST_ID 			= $connection->lastInsertId();
				

				#--------[ UPDATE WAX TREE MAKING - SPLIT JC - jc_no_split_status
				$updt = "UPDATE `wax_tree_making_det` SET `jc_no_split_status`='No', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE `wax_tree_making_det_id`='$wax_tree_making_det_id'";
				$qury = $connection->executeQuery($updt);	
				
				
				#--------[ INSERT WAX TREE MAKING - JOB CARD WEIGHT DATAs - SPLIT JC
				$instWAXtreeMAKINGwgtDATA = "INSERT INTO `wax_tree_making_det`(`wax_tree_making_id`, `po_open_ord_id`, `po_open_ord_det_id`, `jc_no`, `act_po_open_ord_det_id`, `st_wg`, `item_qty`, `jc_orn_wgt`, `sepration_emp_id`, `sepration_date`, `post_by`, `post_dt`) VALUES ('$wax_tree_making_id', '$po_open_ord_id', '$LAST_ID', '$job_card_no', '$wax_tree_making_det_id', '$st_wg', '$qty', '$jc_split_wgt', '$sepration_emp_id', '$sepration_date', '$sessionId', '$nowDateTime')";
				$stmtWAXtreeMAKINGwgtDATA = $connection->executeQuery($instWAXtreeMAKINGwgtDATA);	
			}

			return $this->redirect('separation-list');
		}		
		
		return $this->render('dept/split-jc.html.twig', [
			'jcNOdata' => $FTCHjcNO,
			'openORDjc' => $openORDjc,
			'empLIST' => $FTCHemp,
			'controller_name' => 'SeparationDeptController'
        ]);	
	}				
}